<?php
/*--------------------------------------------------------------
   Configured.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Events;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\UpdateSet;

class Configured
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     *
     * @var UpdateSet
     */
    private $updateSet;
    
    
    /**
     * Constructor.
     */
    private function __construct(Id $id, UpdateSet $updateSet)
    {
        $this->id        = $id;
        $this->updateSet = $updateSet;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Id $id, UpdateSet $updateSet): self
    {
        return new self($id, $updateSet);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * Return update set.
     */
    public function updateSet(): UpdateSet
    {
        return $this->updateSet;
    }
}